/*
 * Decompiled with CFR 0.152.
 */
package ing.meowdd.ahsniper.scanner;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import ing.meowdd.ahsniper.AhSniperMod;
import ing.meowdd.ahsniper.config.AhSniperConfig;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AhSniperScannerService {
    private static final String AUCTIONS_PAGE_URI = "https://api.hypixel.net/v2/skyblock/auctions?page=%d";
    private static final int MAX_EMITTED_ALERTS_PER_POLL = 3;
    private static final int MAX_OPPORTUNITIES = 8;
    private static final int MAX_TRACKED_IDS = 9000;
    private static final int MAX_PAGES_SAFETY_LIMIT = 140;
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("\u00a7.");
    private static final Pattern STAR_SUFFIX_PATTERN = Pattern.compile("\\s*[\u272a\u272b\u278a\u278b\u278c\u278d\u278e]+\\s*$");
    private static final Pattern LEADING_DECOR_PATTERN = Pattern.compile("^[^\\p{Alnum}]+\\s*");
    private static final Pattern ROMAN_SUFFIX_PATTERN = Pattern.compile("\\s+[IVXLCM]+$", 2);
    private static final Pattern ABILITY_PATTERN = Pattern.compile("Ability:\\s*([^\\r\\n]+?)(?:\\s{2,}|$)", 2);
    private final ScheduledExecutorService scheduler;
    private final HttpClient httpClient;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Map<String, Long> notifiedAuctions = new HashMap<String, Long>();
    private ScheduledFuture<?> task;
    private volatile long totalPolls;
    private volatile long lastPollEpochMs;
    private volatile String lastOpportunity = "none";
    private volatile String lastScannerStatus = "idle";
    private volatile List<Opportunity> latestOpportunities = List.of();
    private volatile AlertListener alertListener = opportunities -> {};
    private volatile long lastMarketSnapshotId;
    private volatile int lastMarketPages;
    private volatile long lastMarketRefreshEpochMs;
    private volatile Map<String, Long> cachedCheapestByVariant = Map.of();
    private volatile List<AuctionRow> cachedAuctions = List.of();
    private volatile Set<String> baselineAuctionIds = Set.of();
    private volatile Map<String, Long> baselineCheapestByVariant = Map.of();
    private volatile boolean baselineReady;

    public AhSniperScannerService() {
        ThreadFactory factory = runnable -> {
            Thread thread = new Thread(runnable, "AH-Sniper-Scanner");
            thread.setDaemon(true);
            return thread;
        };
        this.scheduler = Executors.newSingleThreadScheduledExecutor(factory);
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(6L)).build();
    }

    public synchronized boolean isRunning() {
        return this.running.get();
    }

    public synchronized long getTotalPolls() {
        return this.totalPolls;
    }

    public synchronized long getLastPollEpochMs() {
        return this.lastPollEpochMs;
    }

    public synchronized String getLastOpportunity() {
        return this.lastOpportunity;
    }

    public synchronized String getLastScannerStatus() {
        return this.lastScannerStatus;
    }

    public synchronized List<Opportunity> getLatestOpportunities() {
        return List.copyOf(this.latestOpportunities);
    }

    public synchronized void setAlertListener(AlertListener listener) {
        this.alertListener = listener == null ? opportunities -> {} : listener;
    }

    public synchronized void start(AhSniperConfig config) {
        if (this.running.get()) {
            return;
        }
        long intervalMs = Math.max(1000, config.pollIntervalMs);
        this.task = this.scheduler.scheduleWithFixedDelay(this::pollHypixelAuctions, 0L, intervalMs, TimeUnit.MILLISECONDS);
        this.running.set(true);
        AhSniperMod.LOGGER.info("[AH-Sniper] Scanner started ({} ms delay).", (Object)intervalMs);
    }

    public synchronized void stop() {
        if (!this.running.get()) {
            return;
        }
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
        this.running.set(false);
        this.lastScannerStatus = "stopped";
        this.notifiedAuctions.clear();
        this.latestOpportunities = List.of();
        this.baselineReady = false;
        this.baselineAuctionIds = Set.of();
        this.baselineCheapestByVariant = Map.of();
        this.cachedAuctions = List.of();
        this.cachedCheapestByVariant = Map.of();
        AhSniperMod.LOGGER.info("[AH-Sniper] Scanner stopped.");
    }

    public synchronized void restart(AhSniperConfig config) {
        this.stop();
        this.start(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollHypixelAuctions() {
        AlertListener listenerSnapshot;
        Object status;
        long now = System.currentTimeMillis();
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        long minProfitCoins = (long)Math.max(1, config.minProfitMillions) * 1000000L;
        long minGapToNextBinCoins = (long)Math.max(1, config.minGapToNextBinMillions) * 1000000L;
        long requiredUndercutCoins = Math.max(minProfitCoins, minGapToNextBinCoins);
        long maxBuyCoins = (long)Math.max(1, config.maxBuyPriceMillions) * 1000000L;
        List<Opportunity> opportunities = List.of();
        List<Object> alertsToEmit = List.of();
        DetectionResult detection = null;
        try {
            boolean baselineReadySnapshot;
            Map<String, Long> baselineCheapestSnapshot;
            Set<String> baselineIdsSnapshot;
            MarketSnapshot snapshot = this.loadMarketSnapshot(now);
            AhSniperScannerService ahSniperScannerService = this;
            synchronized (ahSniperScannerService) {
                baselineIdsSnapshot = this.baselineAuctionIds;
                baselineCheapestSnapshot = this.baselineCheapestByVariant;
                baselineReadySnapshot = this.baselineReady;
            }
            detection = this.detectOpportunities(snapshot.auctions, snapshot.cheapestByVariant, baselineIdsSnapshot, baselineCheapestSnapshot, baselineReadySnapshot, requiredUndercutCoins, maxBuyCoins, now);
            opportunities = detection.opportunities;
            status = !detection.baselineWasReady ? String.format(Locale.US, "warmup | auctions %d | variants %d | pages %d | %s", snapshot.auctions.size(), snapshot.cheapestByVariant.size(), snapshot.totalPages, snapshot.refreshed ? "refreshed" : "cached") : String.format(Locale.US, "ok %d opp | new %d | variants %d | pages %d | %s", opportunities.size(), detection.newAuctionCount, snapshot.cheapestByVariant.size(), snapshot.totalPages, snapshot.refreshed ? "refreshed" : "cached");
        }
        catch (Exception refreshError) {
            MarketSnapshot fallback = this.getCachedSnapshotFallback();
            if (fallback != null) {
                boolean baselineReadySnapshot;
                Map<String, Long> baselineCheapestSnapshot;
                Set<String> baselineIdsSnapshot;
                AhSniperScannerService ahSniperScannerService = this;
                synchronized (ahSniperScannerService) {
                    baselineIdsSnapshot = this.baselineAuctionIds;
                    baselineCheapestSnapshot = this.baselineCheapestByVariant;
                    baselineReadySnapshot = this.baselineReady;
                }
                detection = this.detectOpportunities(fallback.auctions, fallback.cheapestByVariant, baselineIdsSnapshot, baselineCheapestSnapshot, baselineReadySnapshot, requiredUndercutCoins, maxBuyCoins, now);
                opportunities = detection.opportunities;
                status = !detection.baselineWasReady ? String.format(Locale.US, "warmup cache | auctions %d | variants %d | pages %d", fallback.auctions.size(), fallback.cheapestByVariant.size(), fallback.totalPages) : String.format(Locale.US, "degraded cache | opp %d | new %d | variants %d | pages %d", opportunities.size(), detection.newAuctionCount, fallback.cheapestByVariant.size(), fallback.totalPages);
                AhSniperMod.LOGGER.debug("[AH-Sniper] Refresh failed, using cached market snapshot.", (Throwable)refreshError);
            }
            status = "error: " + AhSniperScannerService.compactError(refreshError.getMessage());
            AhSniperMod.LOGGER.debug("[AH-Sniper] Poll failed", (Throwable)refreshError);
        }
        AhSniperScannerService refreshError = this;
        synchronized (refreshError) {
            ++this.totalPolls;
            this.lastPollEpochMs = now;
            this.latestOpportunities = opportunities;
            this.lastScannerStatus = status;
            if (detection != null) {
                this.baselineAuctionIds = detection.currentAuctionIds;
                this.baselineCheapestByVariant = detection.currentCheapestByVariant;
                this.baselineReady = true;
            }
            alertsToEmit = this.collectFreshAlertsLocked(opportunities, now, config.alertCooldownSeconds);
            listenerSnapshot = this.alertListener;
            if (!opportunities.isEmpty()) {
                Opportunity top = opportunities.get(0);
                this.lastOpportunity = top.itemName + " +" + AhSniperScannerService.formatMillions(top.estimatedProfitCoins);
            } else if (((String)status).startsWith("ok") || ((String)status).startsWith("degraded")) {
                this.lastOpportunity = "none";
            }
        }
        if (!alertsToEmit.isEmpty()) {
            try {
                listenerSnapshot.onOpportunities(alertsToEmit);
            }
            catch (Exception e) {
                AhSniperMod.LOGGER.debug("[AH-Sniper] Alert listener failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarketSnapshot loadMarketSnapshot(long now) throws IOException, InterruptedException {
        PagePayload pageZero = this.fetchAuctionsPage(0);
        long snapshotId = pageZero.lastUpdated;
        int totalPages = Math.max(1, Math.min(140, pageZero.totalPages));
        MarketSnapshot cached = this.getCachedSnapshotFallback();
        if (cached != null && cached.snapshotId == snapshotId) {
            return cached;
        }
        ArrayList<AuctionRow> auctions = new ArrayList<AuctionRow>(this.parseAuctionRows(pageZero.auctions));
        for (int page = 1; page < totalPages; ++page) {
            PagePayload payload = this.fetchAuctionsPage(page);
            auctions.addAll(this.parseAuctionRows(payload.auctions));
        }
        Map<String, Long> cheapestByVariant = this.computeCheapestByVariant(auctions);
        MarketSnapshot refreshed = new MarketSnapshot(snapshotId, totalPages, List.copyOf(auctions), Map.copyOf(cheapestByVariant), true);
        AhSniperScannerService ahSniperScannerService = this;
        synchronized (ahSniperScannerService) {
            this.lastMarketSnapshotId = snapshotId;
            this.lastMarketPages = totalPages;
            this.lastMarketRefreshEpochMs = now;
            this.cachedAuctions = refreshed.auctions;
            this.cachedCheapestByVariant = refreshed.cheapestByVariant;
        }
        return refreshed;
    }

    private synchronized MarketSnapshot getCachedSnapshotFallback() {
        if (this.cachedAuctions.isEmpty()) {
            return null;
        }
        return new MarketSnapshot(this.lastMarketSnapshotId, this.lastMarketPages, this.cachedAuctions, this.cachedCheapestByVariant, false);
    }

    private PagePayload fetchAuctionsPage(int page) throws IOException, InterruptedException {
        URI uri = URI.create(String.format(Locale.US, AUCTIONS_PAGE_URI, Math.max(0, page)));
        HttpRequest request = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(10L)).header("User-Agent", "AH-Sniper-Mod/1.0").GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("HTTP " + response.statusCode());
        }
        JsonObject root = JsonParser.parseString((String)response.body()).getAsJsonObject();
        if (!root.has("success") || !root.get("success").getAsBoolean()) {
            throw new IOException("Hypixel API response success=false");
        }
        if (!root.has("auctions") || !root.get("auctions").isJsonArray()) {
            throw new IOException("Hypixel API response missing auctions array");
        }
        int totalPages = AhSniperScannerService.getIntOr(root, "totalPages", 1);
        long lastUpdated = AhSniperScannerService.getLongOr(root, "lastUpdated", 0L);
        return new PagePayload(totalPages, lastUpdated, root.getAsJsonArray("auctions"));
    }

    private List<AuctionRow> parseAuctionRows(JsonArray auctions) {
        ArrayList<AuctionRow> rows = new ArrayList<AuctionRow>();
        for (JsonElement element : auctions) {
            long buyPrice;
            JsonObject auction;
            if (!element.isJsonObject() || !(auction = element.getAsJsonObject()).has("bin") || !auction.get("bin").getAsBoolean() || (buyPrice = AhSniperScannerService.getLongOr(auction, "starting_bid", -1L)) <= 0L) continue;
            String itemName = AhSniperScannerService.getStringOr(auction, "item_name", "Unknown Item");
            String auctionUuid = AhSniperScannerService.getStringOr(auction, "uuid", "");
            String variantKey = AhSniperScannerService.buildVariantKey(auction, itemName);
            long startEpochMs = AhSniperScannerService.getLongOr(auction, "start", 0L);
            if (variantKey.isBlank()) continue;
            rows.add(new AuctionRow(auctionUuid, itemName, variantKey, buyPrice, startEpochMs));
        }
        return rows;
    }

    private Map<String, Long> computeCheapestByVariant(List<AuctionRow> auctions) {
        HashMap<String, Long> cheapest = new HashMap<String, Long>();
        for (AuctionRow row : auctions) {
            Long current;
            if (row.buyPriceCoins <= 0L || (current = (Long)cheapest.get(row.variantKey)) != null && row.buyPriceCoins >= current) continue;
            cheapest.put(row.variantKey, row.buyPriceCoins);
        }
        return cheapest;
    }

    private DetectionResult detectOpportunities(List<AuctionRow> auctions, Map<String, Long> currentCheapestByVariant, Set<String> previousAuctionIds, Map<String, Long> previousCheapestByVariant, boolean baselineWasReady, long requiredUndercutCoins, long maxBuyCoins, long now) {
        HashSet<String> currentAuctionIds = new HashSet<String>(Math.max(16, auctions.size() * 2));
        for (AuctionRow auctionRow : auctions) {
            if (auctionRow.auctionUuid == null || auctionRow.auctionUuid.isBlank()) continue;
            currentAuctionIds.add(auctionRow.auctionUuid);
        }
        if (!baselineWasReady || previousAuctionIds.isEmpty() || previousCheapestByVariant.isEmpty()) {
            return new DetectionResult(List.of(), Set.copyOf(currentAuctionIds), Map.copyOf(currentCheapestByVariant), 0, false);
        }
        ArrayList<AuctionRow> newRows = new ArrayList<AuctionRow>();
        for (AuctionRow row3 : auctions) {
            if (row3.auctionUuid == null || row3.auctionUuid.isBlank() || previousAuctionIds.contains(row3.auctionUuid)) continue;
            newRows.add(row3);
        }
        if (newRows.isEmpty()) {
            return new DetectionResult(List.of(), Set.copyOf(currentAuctionIds), Map.copyOf(currentCheapestByVariant), 0, true);
        }
        newRows.sort(Comparator.comparingLong(row -> row.startEpochMs).thenComparingLong(row -> row.buyPriceCoins));
        HashMap<String, Long> hashMap = new HashMap<String, Long>(previousCheapestByVariant);
        HashMap<String, Opportunity> bestByVariant = new HashMap<String, Opportunity>();
        for (AuctionRow row4 : newRows) {
            long undercutCoins;
            if (row4.buyPriceCoins <= 0L || row4.buyPriceCoins > maxBuyCoins) continue;
            long previousCheapest = hashMap.getOrDefault(row4.variantKey, Long.MAX_VALUE);
            if (previousCheapest != Long.MAX_VALUE && row4.buyPriceCoins < previousCheapest && (undercutCoins = previousCheapest - row4.buyPriceCoins) >= requiredUndercutCoins) {
                Opportunity current = new Opportunity(row4.auctionUuid, row4.variantKey, row4.itemName, row4.buyPriceCoins, previousCheapest, undercutCoins, now);
                Opportunity previous = (Opportunity)bestByVariant.get(row4.variantKey);
                if (previous == null || current.estimatedProfitCoins > previous.estimatedProfitCoins) {
                    bestByVariant.put(row4.variantKey, current);
                }
            }
            if (row4.buyPriceCoins >= previousCheapest) continue;
            hashMap.put(row4.variantKey, row4.buyPriceCoins);
        }
        ArrayList<Object> sorted = new ArrayList(bestByVariant.values());
        sorted.sort((a, b) -> Long.compare(b.estimatedProfitCoins, a.estimatedProfitCoins));
        if (sorted.size() > 8) {
            sorted = new ArrayList(sorted.subList(0, 8));
        }
        return new DetectionResult(List.copyOf(sorted), Set.copyOf(currentAuctionIds), Map.copyOf(currentCheapestByVariant), newRows.size(), true);
    }

    private List<Opportunity> collectFreshAlertsLocked(List<Opportunity> opportunities, long now, int cooldownSeconds) {
        long cooldownMs = (long)Math.max(5, cooldownSeconds) * 1000L;
        this.notifiedAuctions.entrySet().removeIf(entry -> now - (Long)entry.getValue() > cooldownMs);
        ArrayList<Opportunity> fresh = new ArrayList<Opportunity>();
        for (Opportunity opportunity : opportunities) {
            String key = AhSniperScannerService.alertKey(opportunity);
            Long lastAlert = this.notifiedAuctions.get(key);
            if (lastAlert != null && now - lastAlert < cooldownMs) continue;
            this.notifiedAuctions.put(key, now);
            fresh.add(opportunity);
            if (fresh.size() < 3) continue;
            break;
        }
        if (this.notifiedAuctions.size() > 9000) {
            Iterator<Map.Entry<String, Long>> iterator = this.notifiedAuctions.entrySet().iterator();
            for (int overflow = this.notifiedAuctions.size() - 9000; iterator.hasNext() && overflow > 0; --overflow) {
                iterator.next();
                iterator.remove();
            }
        }
        return fresh;
    }

    private static String alertKey(Opportunity opportunity) {
        if (opportunity.auctionUuid != null && !opportunity.auctionUuid.isBlank()) {
            return opportunity.auctionUuid;
        }
        if (opportunity.variantKey != null && !opportunity.variantKey.isBlank()) {
            return opportunity.variantKey;
        }
        return AhSniperScannerService.normalizeItemKey(opportunity.itemName) + ":" + opportunity.buyPriceCoins;
    }

    private static String buildVariantKey(JsonObject auction, String rawItemName) {
        String safeRawName = rawItemName == null ? "" : rawItemName;
        String itemLoreRaw = AhSniperScannerService.getStringOr(auction, "item_lore", "");
        String extraRaw = AhSniperScannerService.getStringOr(auction, "extra", "");
        String combinedDetail = itemLoreRaw.isBlank() ? extraRaw : itemLoreRaw + "\n" + extraRaw;
        String baseName = AhSniperScannerService.sanitizeBaseName(safeRawName);
        String baseKey = AhSniperScannerService.normalizeItemKey(baseName);
        if (baseKey.isBlank()) {
            baseKey = AhSniperScannerService.normalizeItemKey(safeRawName);
        }
        if (baseKey.isBlank()) {
            return "";
        }
        String tier = AhSniperScannerService.normalizeItemKey(AhSniperScannerService.getStringOr(auction, "tier", "unknown"));
        String category = AhSniperScannerService.normalizeItemKey(AhSniperScannerService.getStringOr(auction, "category", "misc"));
        int stars = AhSniperScannerService.countChar(safeRawName, '\u272a');
        int masterStars = AhSniperScannerService.countAnyChar(safeRawName, "\u278a\u278b\u278c\u278d\u278e");
        String ultimateEnchant = AhSniperScannerService.normalizeItemKey(AhSniperScannerService.extractUltimateEnchantSignature(combinedDetail));
        String abilitySignature = AhSniperScannerService.normalizeItemKey(AhSniperScannerService.extractAbilitySignature(combinedDetail));
        StringBuilder key = new StringBuilder(baseKey.length() + 48);
        key.append(baseKey).append("|t=").append(tier.isBlank() ? "unknown" : tier).append("|c=").append(category.isBlank() ? "misc" : category).append("|s=").append(stars).append("|ms=").append(masterStars);
        if (!ultimateEnchant.isBlank()) {
            key.append("|u=").append(ultimateEnchant);
        }
        if (!abilitySignature.isBlank()) {
            key.append("|ab=").append(abilitySignature);
        }
        return key.toString();
    }

    private static String sanitizeBaseName(String rawItemName) {
        String plain = AhSniperScannerService.stripColorCodes(rawItemName);
        if (plain.isBlank()) {
            return "";
        }
        String withoutLead = LEADING_DECOR_PATTERN.matcher(plain).replaceFirst("").trim();
        String withoutStars = STAR_SUFFIX_PATTERN.matcher(withoutLead).replaceFirst("").trim();
        String selected = withoutStars.isBlank() ? plain : withoutStars;
        return selected.replaceAll("\\s+", " ").trim();
    }

    private static String stripColorCodes(String value) {
        if (value == null || value.isBlank()) {
            return "";
        }
        String normalized = value.replace("\u00c2", "");
        String withoutCodes = COLOR_CODE_PATTERN.matcher(normalized).replaceAll("");
        return withoutCodes.trim();
    }

    private static int countChar(String text, char needle) {
        if (text == null || text.isBlank()) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != needle) continue;
            ++total;
        }
        return total;
    }

    private static int countAnyChar(String text, String needles) {
        if (text == null || text.isBlank() || needles == null || needles.isBlank()) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (needles.indexOf(text.charAt(i)) < 0) continue;
            ++total;
        }
        return total;
    }

    private static String extractUltimateEnchantSignature(String loreRaw) {
        String[] lines;
        if (loreRaw == null || loreRaw.isBlank()) {
            return "";
        }
        String normalizedRaw = loreRaw.replace("\u00c2", "");
        for (String line : lines = normalizedRaw.split("\\r?\\n")) {
            String plain;
            if (line == null || !line.contains("\u00a7d\u00a7l") || (plain = AhSniperScannerService.stripColorCodes(line)).isBlank()) continue;
            String firstSegment = plain.split(",")[0].trim();
            String upper = (firstSegment = ROMAN_SUFFIX_PATTERN.matcher(firstSegment).replaceAll("").trim()).toUpperCase(Locale.ROOT);
            if (upper.contains("DUNGEON") || upper.contains("RARITY") || firstSegment.length() > 32) continue;
            return firstSegment;
        }
        return "";
    }

    private static String extractAbilitySignature(String loreRaw) {
        if (loreRaw == null || loreRaw.isBlank()) {
            return "";
        }
        String plainLore = AhSniperScannerService.stripColorCodes(loreRaw);
        if (plainLore.isBlank()) {
            return "";
        }
        LinkedHashSet<String> signatures = new LinkedHashSet<String>();
        Matcher matcher = ABILITY_PATTERN.matcher(plainLore);
        while (matcher.find()) {
            String ability = AhSniperScannerService.cleanupSignatureToken(matcher.group(1));
            if (!ability.isBlank()) {
                signatures.add(ability);
            }
            if (signatures.size() < 3) continue;
            break;
        }
        if (signatures.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"+", signatures);
    }

    private static String cleanupSignatureToken(String value) {
        if (value == null || value.isBlank()) {
            return "";
        }
        String cleaned = value.replaceAll("(?i)\\b(RIGHT CLICK|LEFT CLICK|SHIFT|SNEAK|HOLD)\\b.*$", "");
        cleaned = cleaned.replaceAll("[^A-Za-z0-9 +'\\-]", " ");
        return cleaned.replaceAll("\\s+", " ").trim();
    }

    private static String normalizeItemKey(String input) {
        String plain = AhSniperScannerService.stripColorCodes(input);
        if (plain.isBlank()) {
            return "";
        }
        return plain.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\s\\-\\[\\]]", "").replaceAll("\\s+", " ").trim();
    }

    private static String getStringOr(JsonObject object, String key, String fallback) {
        if (!object.has(key) || object.get(key).isJsonNull()) {
            return fallback;
        }
        try {
            return object.get(key).getAsString();
        }
        catch (Exception ignored) {
            return fallback;
        }
    }

    private static int getIntOr(JsonObject object, String key, int fallback) {
        if (!object.has(key) || object.get(key).isJsonNull()) {
            return fallback;
        }
        try {
            return object.get(key).getAsInt();
        }
        catch (Exception ignored) {
            return fallback;
        }
    }

    private static long getLongOr(JsonObject object, String key, long fallback) {
        if (!object.has(key) || object.get(key).isJsonNull()) {
            return fallback;
        }
        try {
            return object.get(key).getAsLong();
        }
        catch (Exception ignored) {
            return fallback;
        }
    }

    private static String compactError(String message) {
        if (message == null || message.isBlank()) {
            return "unknown";
        }
        String cleaned = message.replaceAll("\\s+", " ").trim();
        return cleaned.length() > 64 ? cleaned.substring(0, 64) + "..." : cleaned;
    }

    private static String formatMillions(long coins) {
        return String.format(Locale.US, "%.1fM", (double)coins / 1000000.0);
    }

    @FunctionalInterface
    public static interface AlertListener {
        public void onOpportunities(List<Opportunity> var1);
    }

    private static final class MarketSnapshot {
        private final long snapshotId;
        private final int totalPages;
        private final List<AuctionRow> auctions;
        private final Map<String, Long> cheapestByVariant;
        private final boolean refreshed;

        private MarketSnapshot(long snapshotId, int totalPages, List<AuctionRow> auctions, Map<String, Long> cheapestByVariant, boolean refreshed) {
            this.snapshotId = snapshotId;
            this.totalPages = totalPages;
            this.auctions = auctions;
            this.cheapestByVariant = cheapestByVariant;
            this.refreshed = refreshed;
        }
    }

    private static final class DetectionResult {
        private final List<Opportunity> opportunities;
        private final Set<String> currentAuctionIds;
        private final Map<String, Long> currentCheapestByVariant;
        private final int newAuctionCount;
        private final boolean baselineWasReady;

        private DetectionResult(List<Opportunity> opportunities, Set<String> currentAuctionIds, Map<String, Long> currentCheapestByVariant, int newAuctionCount, boolean baselineWasReady) {
            this.opportunities = opportunities;
            this.currentAuctionIds = currentAuctionIds;
            this.currentCheapestByVariant = currentCheapestByVariant;
            this.newAuctionCount = newAuctionCount;
            this.baselineWasReady = baselineWasReady;
        }
    }

    public static final class Opportunity {
        public final String auctionUuid;
        public final String variantKey;
        public final String itemName;
        public final long buyPriceCoins;
        public final long referencePriceCoins;
        public final long estimatedProfitCoins;
        public final long detectedAtEpochMs;

        public Opportunity(String auctionUuid, String variantKey, String itemName, long buyPriceCoins, long referencePriceCoins, long estimatedProfitCoins, long detectedAtEpochMs) {
            this.auctionUuid = auctionUuid;
            this.variantKey = variantKey;
            this.itemName = itemName;
            this.buyPriceCoins = buyPriceCoins;
            this.referencePriceCoins = referencePriceCoins;
            this.estimatedProfitCoins = estimatedProfitCoins;
            this.detectedAtEpochMs = detectedAtEpochMs;
        }
    }

    private static final class PagePayload {
        private final int totalPages;
        private final long lastUpdated;
        private final JsonArray auctions;

        private PagePayload(int totalPages, long lastUpdated, JsonArray auctions) {
            this.totalPages = totalPages;
            this.lastUpdated = lastUpdated;
            this.auctions = auctions;
        }
    }

    private static final class AuctionRow {
        private final String auctionUuid;
        private final String itemName;
        private final String variantKey;
        private final long buyPriceCoins;
        private final long startEpochMs;

        private AuctionRow(String auctionUuid, String itemName, String variantKey, long buyPriceCoins, long startEpochMs) {
            this.auctionUuid = auctionUuid;
            this.itemName = itemName;
            this.variantKey = variantKey;
            this.buyPriceCoins = buyPriceCoins;
            this.startEpochMs = startEpochMs;
        }
    }
}

