/*
 * Decompiled with CFR 0.152.
 */
package ing.meowdd.ahsniper.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ing.meowdd.ahsniper.AhSniperMod;
import ing.meowdd.ahsniper.config.AhSniperConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class AhSniperConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Path configPath;
    private AhSniperConfig config = new AhSniperConfig();

    public AhSniperConfigManager(Path configPath) {
        this.configPath = configPath;
    }

    public synchronized Path getConfigPath() {
        return this.configPath;
    }

    public synchronized AhSniperConfig getConfig() {
        return this.config;
    }

    public synchronized void load() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.config = new AhSniperConfig();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.configPath);){
            AhSniperConfig loaded = (AhSniperConfig)GSON.fromJson((Reader)reader, AhSniperConfig.class);
            this.config = loaded == null ? new AhSniperConfig() : loaded;
            AhSniperConfigManager.sanitize(this.config);
        }
        catch (Exception e) {
            AhSniperMod.LOGGER.error("[AH-Sniper] Failed to read config, using defaults.", (Throwable)e);
            this.config = new AhSniperConfig();
        }
    }

    public synchronized void save() {
        AhSniperConfigManager.sanitize(this.config);
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            AhSniperMod.LOGGER.error("[AH-Sniper] Failed to create config directory.", (Throwable)e);
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
            GSON.toJson((Object)this.config, (Appendable)writer);
        }
        catch (Exception e) {
            AhSniperMod.LOGGER.error("[AH-Sniper] Failed to write config.", (Throwable)e);
        }
    }

    private static void sanitize(AhSniperConfig cfg) {
        if (cfg.minProfitMillions < 1) {
            cfg.minProfitMillions = 1;
        }
        if (cfg.minGapToNextBinMillions < 1) {
            cfg.minGapToNextBinMillions = 1;
        }
        if (cfg.minGapToNextBinMillions > 5000) {
            cfg.minGapToNextBinMillions = 5000;
        }
        if (cfg.maxBuyPriceMillions < 1) {
            cfg.maxBuyPriceMillions = 1;
        }
        if (cfg.pollIntervalMs < 500) {
            cfg.pollIntervalMs = 500;
        }
        if (cfg.pollIntervalMs > 15000) {
            cfg.pollIntervalMs = 15000;
        }
        if (cfg.alertCooldownSeconds < 5) {
            cfg.alertCooldownSeconds = 5;
        }
        if (cfg.alertCooldownSeconds > 300) {
            cfg.alertCooldownSeconds = 300;
        }
        if (cfg.discordWebhook == null) {
            cfg.discordWebhook = "";
        }
    }
}

