/*
 * Decompiled with CFR 0.152.
 */
package ing.meowdd.ahsniper;

import ing.meowdd.ahsniper.AhSniperMod;
import ing.meowdd.ahsniper.config.AhSniperConfig;
import ing.meowdd.ahsniper.scanner.AhSniperScannerService;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public final class AhSniperHudOverlay {
    private static final class_2960 HUD_LAYER_ID = class_2960.method_60655((String)"ahsniper", (String)"live_panel");
    private static boolean firstRenderLogged;

    private AhSniperHudOverlay() {
    }

    public static void register() {
        boolean registeredWithLayerApi = false;
        try {
            HudElementRegistry.addLast((class_2960)HUD_LAYER_ID, AhSniperHudOverlay::renderHud);
            registeredWithLayerApi = true;
            AhSniperMod.LOGGER.info("[AH-Sniper] HUD registered with HudElementRegistry.");
        }
        catch (Throwable error) {
            AhSniperMod.LOGGER.warn("[AH-Sniper] HudElementRegistry unavailable, using HudRenderCallback fallback: {}", (Object)error.getMessage());
        }
        if (!registeredWithLayerApi) {
            HudRenderCallback.EVENT.register(AhSniperHudOverlay::renderHud);
        }
    }

    private static void renderHud(class_332 drawContext, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (!firstRenderLogged) {
            firstRenderLogged = true;
            AhSniperMod.LOGGER.info("[AH-Sniper] HUD first render pass executed.");
        }
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        if (!config.hudEnabled) {
            return;
        }
        List<AhSniperScannerService.Opportunity> opportunities = AhSniperMod.SCANNER_SERVICE.getLatestOpportunities();
        int shown = Math.min(3, opportunities.size());
        int x = 8;
        int y = 8;
        int width = 308;
        int height = shown == 0 ? 92 : 88 + shown * 20;
        String scannerStatus = AhSniperHudOverlay.trim(AhSniperMod.SCANNER_SERVICE.getLastScannerStatus(), 40);
        String pollInfo = "waiting";
        long lastPoll = AhSniperMod.SCANNER_SERVICE.getLastPollEpochMs();
        if (lastPoll > 0L) {
            long deltaMs = Math.max(0L, System.currentTimeMillis() - lastPoll);
            pollInfo = String.format(Locale.US, "%.1fs ago", (double)deltaMs / 1000.0);
        }
        long polls = AhSniperMod.SCANNER_SERVICE.getTotalPolls();
        int scannerColor = config.scannerEnabled ? -8454225 : -25976;
        int apiColor = AhSniperHudOverlay.statusColor(scannerStatus);
        drawContext.method_51433(client.field_1772, "AH HUD", x, y - 8, -1, true);
        drawContext.method_25294(x - 4, y - 4, x + width, y + height, -804252896);
        drawContext.method_25294(x - 4, y - 4, x + width, y - 3, -9656600);
        drawContext.method_25294(x - 4, y + height - 1, x + width, y + height, -9656600);
        drawContext.method_25294(x - 4, y - 4, x - 3, y + height, -9656600);
        drawContext.method_25294(x + width - 1, y - 4, x + width, y + height, -9656600);
        drawContext.method_51433(client.field_1772, "AH-Sniper Live Panel", x, y, -6728, true);
        drawContext.method_51433(client.field_1772, "SCANNER: " + (config.scannerEnabled ? "ON" : "OFF"), x, y + 12, scannerColor, false);
        drawContext.method_51433(client.field_1772, "API: " + scannerStatus, x + 114, y + 12, apiColor, false);
        drawContext.method_51433(client.field_1772, "POLL: " + pollInfo + "  |  TOTAL: " + polls, x, y + 24, -3681304, false);
        drawContext.method_51433(client.field_1772, "FILTERS: +" + config.minProfitMillions + "M profit  |  -" + config.minGapToNextBinMillions + "M vs prev cheapest  |  <= " + config.maxBuyPriceMillions + "M", x, y + 36, -797797, false);
        drawContext.method_25294(x, y + 45, x + width - 8, y + 46, -12689528);
        int lineY = y + 52;
        if (shown == 0) {
            drawContext.method_51433(client.field_1772, "No opportunities yet.", x, lineY, -4669752, false);
            drawContext.method_51433(client.field_1772, "Learning global market medians per variant...", x, lineY + 12, -6510404, false);
            return;
        }
        for (int i = 0; i < shown; ++i) {
            AhSniperScannerService.Opportunity opportunity = opportunities.get(i);
            String lineA = String.format(Locale.US, "%d) %s", i + 1, AhSniperHudOverlay.trim(opportunity.itemName, 34));
            String lineB = String.format(Locale.US, "   Profit +%s  |  Buy %s  |  Prev %s", AhSniperHudOverlay.formatMillions(opportunity.estimatedProfitCoins), AhSniperHudOverlay.formatMillions(opportunity.buyPriceCoins), AhSniperHudOverlay.formatMillions(opportunity.referencePriceCoins));
            int rowY = lineY + i * 20;
            drawContext.method_51433(client.field_1772, lineA, x, rowY, -2299656, false);
            drawContext.method_51433(client.field_1772, lineB, x, rowY + 10, -8454225, false);
        }
    }

    private static String formatMillions(long coins) {
        return String.format(Locale.US, "%.1fM", (double)coins / 1000000.0);
    }

    private static String trim(String value, int maxLen) {
        if (value == null || value.isBlank()) {
            return "-";
        }
        if (value.length() <= maxLen) {
            return value;
        }
        return value.substring(0, maxLen - 3) + "...";
    }

    private static int statusColor(String status) {
        if (status == null || status.isBlank()) {
            return -3090461;
        }
        String normalized = status.toLowerCase(Locale.ROOT);
        if (normalized.startsWith("ok")) {
            return -8454225;
        }
        if (normalized.startsWith("error")) {
            return -25976;
        }
        return -1518186;
    }
}

