/*
 * Decompiled with CFR 0.152.
 */
package ing.meowdd.ahsniper;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import ing.meowdd.ahsniper.AhSniperMod;
import ing.meowdd.ahsniper.config.AhSniperConfig;
import ing.meowdd.ahsniper.scanner.AhSniperScannerService;
import ing.meowdd.ahsniper.ui.AhSniperConfigScreen;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class AhSniperClientCommands {
    private AhSniperClientCommands() {
    }

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ahsniper").executes(context -> AhSniperClientCommands.sendStatus((FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.literal((String)"status").executes(context -> AhSniperClientCommands.sendStatus((FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"panel").executes(context -> AhSniperClientCommands.openPanel((FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"toggle").executes(context -> AhSniperClientCommands.setScannerEnabled((FabricClientCommandSource)context.getSource(), !AhSniperMod.CONFIG_MANAGER.getConfig().scannerEnabled)))).then(ClientCommandManager.literal((String)"on").executes(context -> AhSniperClientCommands.setScannerEnabled((FabricClientCommandSource)context.getSource(), true)))).then(ClientCommandManager.literal((String)"off").executes(context -> AhSniperClientCommands.setScannerEnabled((FabricClientCommandSource)context.getSource(), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"hud").executes(context -> AhSniperClientCommands.toggleHud((FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.literal((String)"toggle").executes(context -> AhSniperClientCommands.toggleHud((FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"on").executes(context -> AhSniperClientCommands.setHud((FabricClientCommandSource)context.getSource(), true)))).then(ClientCommandManager.literal((String)"off").executes(context -> AhSniperClientCommands.setHud((FabricClientCommandSource)context.getSource(), false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"alerts").executes(context -> AhSniperClientCommands.sendAlertsStatus((FabricClientCommandSource)context.getSource()))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"chat").then(ClientCommandManager.literal((String)"on").executes(context -> AhSniperClientCommands.setChatAlerts((FabricClientCommandSource)context.getSource(), true)))).then(ClientCommandManager.literal((String)"off").executes(context -> AhSniperClientCommands.setChatAlerts((FabricClientCommandSource)context.getSource(), false))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sound").then(ClientCommandManager.literal((String)"on").executes(context -> AhSniperClientCommands.setSoundAlerts((FabricClientCommandSource)context.getSource(), true)))).then(ClientCommandManager.literal((String)"off").executes(context -> AhSniperClientCommands.setSoundAlerts((FabricClientCommandSource)context.getSource(), false))))).then(ClientCommandManager.literal((String)"cooldown").then(ClientCommandManager.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)5, (int)300)).executes(context -> AhSniperClientCommands.setAlertCooldown((FabricClientCommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"webhook").executes(context -> AhSniperClientCommands.showWebhook((FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.literal((String)"show").executes(context -> AhSniperClientCommands.showWebhook((FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"clear").executes(context -> AhSniperClientCommands.clearWebhook((FabricClientCommandSource)context.getSource())))).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(context -> AhSniperClientCommands.setWebhook((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"url"))))))).then(ClientCommandManager.literal((String)"minprofit").then(ClientCommandManager.argument((String)"millions", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2000)).executes(context -> AhSniperClientCommands.setMinProfit((FabricClientCommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"millions")))))).then(ClientCommandManager.literal((String)"mingap").then(ClientCommandManager.argument((String)"millions", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5000)).executes(context -> AhSniperClientCommands.setMinGapToNextBin((FabricClientCommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"millions")))))).then(ClientCommandManager.literal((String)"maxbuy").then(ClientCommandManager.argument((String)"millions", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10000)).executes(context -> AhSniperClientCommands.setMaxBuyPrice((FabricClientCommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"millions")))))).then(ClientCommandManager.literal((String)"interval").then(ClientCommandManager.argument((String)"ms", (ArgumentType)IntegerArgumentType.integer((int)500, (int)15000)).executes(context -> AhSniperClientCommands.setPollInterval((FabricClientCommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"ms")))))).then(ClientCommandManager.literal((String)"reload").executes(context -> AhSniperClientCommands.reloadConfig((FabricClientCommandSource)context.getSource())))));
    }

    private static int sendStatus(FabricClientCommandSource source) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        long lastPoll = AhSniperMod.SCANNER_SERVICE.getLastPollEpochMs();
        long polls = AhSniperMod.SCANNER_SERVICE.getTotalPolls();
        String scannerStatus = AhSniperMod.SCANNER_SERVICE.getLastScannerStatus();
        List<AhSniperScannerService.Opportunity> opportunities = AhSniperMod.SCANNER_SERVICE.getLatestOpportunities();
        String lastPollLabel = "never";
        if (lastPoll > 0L) {
            long deltaMs = Math.max(0L, System.currentTimeMillis() - lastPoll);
            lastPollLabel = String.format(Locale.US, "%.1fs ago", (double)deltaMs / 1000.0);
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)"[AH-Sniper] Status").method_27692(class_124.field_1065));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Scanner: " + (config.scannerEnabled ? "ON" : "OFF") + " | HUD: " + (config.hudEnabled ? "ON" : "OFF"))).method_27692(class_124.field_1054));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Filters -> MinProfit: " + config.minProfitMillions + "M, MinGapPrev: " + config.minGapToNextBinMillions + "M, MaxBuy: " + config.maxBuyPriceMillions + "M, Interval: " + config.pollIntervalMs + "ms")).method_27692(class_124.field_1080));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Alerts -> Chat: " + AhSniperClientCommands.onOff(config.chatAlertsEnabled) + ", Sound: " + AhSniperClientCommands.onOff(config.soundAlertsEnabled) + ", Cooldown: " + config.alertCooldownSeconds + "s")).method_27692(class_124.field_1080));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Webhook: " + (config.discordWebhook.isBlank() ? "not configured" : "configured"))).method_27692(class_124.field_1080));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Runtime -> Polls: " + polls + ", Last poll: " + lastPollLabel + ", Last signal: " + AhSniperMod.SCANNER_SERVICE.getLastOpportunity())).method_27692(class_124.field_1080));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("API -> " + scannerStatus + " | Tracked opportunities: " + opportunities.size())).method_27692(class_124.field_1080));
        if (!opportunities.isEmpty()) {
            AhSniperScannerService.Opportunity top = opportunities.get(0);
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Top -> " + AhSniperClientCommands.trim(top.itemName, 32) + " +" + AhSniperClientCommands.formatMillions(top.estimatedProfitCoins) + " @ " + AhSniperClientCommands.formatMillions(top.buyPriceCoins))).method_27692(class_124.field_1060));
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Commands: /ahsniper panel | /ahsniper alerts | /ahsniper minprofit <M> | /ahsniper mingap <M> | /ahsniper interval <ms>").method_27692(class_124.field_1063));
        return 1;
    }

    private static int openPanel(FabricClientCommandSource source) {
        source.getClient().method_1507((class_437)new AhSniperConfigScreen(source.getClient().field_1755));
        return 1;
    }

    private static int sendAlertsStatus(FabricClientCommandSource source) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Alerts -> Chat: " + AhSniperClientCommands.onOff(config.chatAlertsEnabled) + ", Sound: " + AhSniperClientCommands.onOff(config.soundAlertsEnabled) + ", Cooldown: " + config.alertCooldownSeconds + "s")).method_27692(class_124.field_1075));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Use: /ahsniper alerts chat on|off | /ahsniper alerts sound on|off | /ahsniper alerts cooldown <seconds>").method_27692(class_124.field_1063));
        return 1;
    }

    private static int setScannerEnabled(FabricClientCommandSource source, boolean enabled) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.scannerEnabled = enabled;
        AhSniperMod.CONFIG_MANAGER.save();
        if (!enabled) {
            AhSniperMod.SCANNER_SERVICE.stop();
        } else if (source.getClient().field_1687 != null) {
            AhSniperMod.SCANNER_SERVICE.start(config);
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Scanner " + (enabled ? "enabled" : "disabled"))).method_27692(enabled ? class_124.field_1060 : class_124.field_1061));
        return 1;
    }

    private static int toggleHud(FabricClientCommandSource source) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        return AhSniperClientCommands.setHud(source, !config.hudEnabled);
    }

    private static int setHud(FabricClientCommandSource source, boolean enabled) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.hudEnabled = enabled;
        AhSniperMod.CONFIG_MANAGER.save();
        source.sendFeedback((class_2561)class_2561.method_43470((String)("HUD " + (enabled ? "enabled" : "disabled"))).method_27692(enabled ? class_124.field_1060 : class_124.field_1061));
        return 1;
    }

    private static int setChatAlerts(FabricClientCommandSource source, boolean enabled) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.chatAlertsEnabled = enabled;
        AhSniperMod.CONFIG_MANAGER.save();
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Chat alerts " + (enabled ? "enabled" : "disabled"))).method_27692(enabled ? class_124.field_1060 : class_124.field_1061));
        return 1;
    }

    private static int setSoundAlerts(FabricClientCommandSource source, boolean enabled) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.soundAlertsEnabled = enabled;
        AhSniperMod.CONFIG_MANAGER.save();
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Sound alerts " + (enabled ? "enabled" : "disabled"))).method_27692(enabled ? class_124.field_1060 : class_124.field_1061));
        return 1;
    }

    private static int setAlertCooldown(FabricClientCommandSource source, int seconds) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.alertCooldownSeconds = seconds;
        AhSniperMod.CONFIG_MANAGER.save();
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Alert cooldown set to " + seconds + "s")).method_27692(class_124.field_1075));
        return 1;
    }

    private static int showWebhook(FabricClientCommandSource source) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        if (config.discordWebhook.isBlank()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Webhook not configured.").method_27692(class_124.field_1080));
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Use: /ahsniper webhook set <url>").method_27692(class_124.field_1063));
            return 1;
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Webhook configured: " + AhSniperClientCommands.maskWebhook(config.discordWebhook))).method_27692(class_124.field_1060));
        return 1;
    }

    private static int setWebhook(FabricClientCommandSource source, String url) {
        String cleaned;
        String string = cleaned = url == null ? "" : url.trim();
        if (cleaned.isBlank()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Webhook URL cannot be empty.").method_27692(class_124.field_1061));
            return 0;
        }
        if (!cleaned.startsWith("https://")) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Webhook URL must start with https://").method_27692(class_124.field_1061));
            return 0;
        }
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.discordWebhook = cleaned;
        AhSniperMod.CONFIG_MANAGER.save();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Discord webhook configured.").method_27692(class_124.field_1060));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Use /ahsniper webhook show to verify.").method_27692(class_124.field_1063));
        return 1;
    }

    private static int clearWebhook(FabricClientCommandSource source) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.discordWebhook = "";
        AhSniperMod.CONFIG_MANAGER.save();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Discord webhook cleared.").method_27692(class_124.field_1054));
        return 1;
    }

    private static int setMinProfit(FabricClientCommandSource source, int millions) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.minProfitMillions = millions;
        AhSniperMod.CONFIG_MANAGER.save();
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Min profit set to " + millions + "M")).method_27692(class_124.field_1075));
        return 1;
    }

    private static int setMinGapToNextBin(FabricClientCommandSource source, int millions) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.minGapToNextBinMillions = millions;
        AhSniperMod.CONFIG_MANAGER.save();
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Min gap vs previous cheapest set to " + millions + "M")).method_27692(class_124.field_1075));
        return 1;
    }

    private static int setMaxBuyPrice(FabricClientCommandSource source, int millions) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.maxBuyPriceMillions = millions;
        AhSniperMod.CONFIG_MANAGER.save();
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Max buy price set to " + millions + "M")).method_27692(class_124.field_1075));
        return 1;
    }

    private static int setPollInterval(FabricClientCommandSource source, int milliseconds) {
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        config.pollIntervalMs = milliseconds;
        AhSniperMod.CONFIG_MANAGER.save();
        if (config.scannerEnabled && source.getClient().field_1687 != null) {
            AhSniperMod.SCANNER_SERVICE.restart(config);
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Poll interval set to " + milliseconds + "ms")).method_27692(class_124.field_1075));
        return 1;
    }

    private static int reloadConfig(FabricClientCommandSource source) {
        boolean scannerWasRunning = AhSniperMod.SCANNER_SERVICE.isRunning();
        AhSniperMod.CONFIG_MANAGER.load();
        AhSniperConfig config = AhSniperMod.CONFIG_MANAGER.getConfig();
        if (source.getClient().field_1687 != null) {
            if (config.scannerEnabled) {
                if (scannerWasRunning) {
                    AhSniperMod.SCANNER_SERVICE.restart(config);
                } else {
                    AhSniperMod.SCANNER_SERVICE.start(config);
                }
            } else {
                AhSniperMod.SCANNER_SERVICE.stop();
            }
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Config reloaded from disk.").method_27692(class_124.field_1060));
        return 1;
    }

    private static String onOff(boolean enabled) {
        return enabled ? "ON" : "OFF";
    }

    private static String maskWebhook(String webhook) {
        if (webhook == null || webhook.isBlank()) {
            return "not configured";
        }
        if (webhook.length() <= 20) {
            return "********";
        }
        return webhook.substring(0, 18) + "...";
    }

    private static String formatMillions(long coins) {
        return String.format(Locale.US, "%.1fM", (double)coins / 1000000.0);
    }

    private static String trim(String value, int maxLen) {
        if (value == null || value.isBlank()) {
            return "unknown";
        }
        if (value.length() <= maxLen) {
            return value;
        }
        return value.substring(0, maxLen - 1) + "...";
    }
}

